//
//  DXAppController.h
//  DefEcs
//
//  Created by ttomek on 06-07-30.
//  Copyright 2006 hipercom.pl. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "DXDomainController.h"
#import "DXAsciiHexConverter.h"
#import "DXKey.h"
#import "DXNumberController.h"
#import "DXDomainEnvelope.h"

@interface DXAppController : NSObject
{
	NSMutableArray* domains;
	
    IBOutlet NSWindow* mainWindow;
	IBOutlet NSBox *domainContentsGroup;
    IBOutlet NSOutlineView *domainContentsView;
    IBOutlet NSBox *domainListGroup;
    IBOutlet NSTableView *domainListView;
    IBOutlet NSSearchField *domainSearchField;
    IBOutlet NSSearchField *keySearchField;
	
	IBOutlet NSWindow* newKeySheet;
	IBOutlet NSWindow* newDomainSheet;
	IBOutlet NSWindow* stringValueSheet;
	IBOutlet NSWindow* numberValueSheet;
	IBOutlet NSWindow* dateValueSheet;
	IBOutlet NSWindow* dataValueSheet;
	
	IBOutlet NSTextField* newKeyNameEdit;
	IBOutlet NSPopUpButton* newKeyTypePopup;
	
	IBOutlet NSTextField* newDomainNameEdit;
	
	IBOutlet NSTextField* stringValueEdit;
	
	IBOutlet NSTextField* numberValueEdit;
	IBOutlet NSMatrix* numberTypeMatrix;
	IBOutlet DXNumberController* numberController;
	
	IBOutlet NSDatePicker* dateValueEdit;
	
	IBOutlet DXAsciiHexConverter* dataValueConverter;
	IBOutlet NSTextField* dataValueHexEdit;
	
	IBOutlet NSWindow* preferencesWindow;
	
	NSWindow* currentSheet;
	DXKey* currentKey;
	DXKey* editedKey;
}

- (void) awakeFromNib;
- (void) reloadDomains;

// domainListView data source methods
- (int) numberOfRowsInTableView: (NSTableView*) aTableView;
- (id)				tableView: (NSTableView*)aTableView 
	objectValueForTableColumn: (NSTableColumn*) aTableColumn
						  row: (int) rowIndex;

- (BOOL) shouldQuit;

// main window's delegate methods
- (void) windowWillClose: (NSNotification*) aNotification;

// domainListView delegate methods
- (void) tableViewSelectionDidChange: (NSNotification *) aNotification;

- (void) setCurrentKey: (DXKey*) aKey;
- (void) setEditedKey: (DXKey*) aKey;

- (IBAction)closeApp:(id)sender;
- (IBAction)deleteDomain:(id)sender;
- (IBAction)deleteKey:(id)sender;
- (void) doExportToFile: (NSSavePanel*) sheet
			 returnCode: (int) returnCode
			contextInfo: (void*) contextInfo;
- (IBAction)exportToFile:(id)sender;
- (void) doExportDomainToFile: (NSSavePanel*) sheet
				   returnCode: (int) returnCode
				  contextInfo: (void*) contextInfo;
- (IBAction) exportDomainToFile: (id) sender;
- (void) doImportDomainFromFile: (NSOpenPanel*) sheet
					 returnCode: (int) returnCode
					contextInfo: (void*) contextInfo;
- (IBAction) importDomainFromFile: (id) sender;
- (void) doImportFromFile: (NSOpenPanel*) sheet
			   returnCode: (int) returnCode
			  contextInfo: (void*) contextInfo;
- (IBAction)importFromFile:(id)sender;
- (IBAction)newDomain:(id)sender;
- (IBAction)newKey:(id)sender;
- (IBAction)preferences:(id)sender;
- (void) doReloadAllDomains: (NSWindow*) sheet
			 returnCode: (int) returnCode
			contextInfo: (void*) contextInfo;
- (IBAction)reloadAllDomains:(id)sender;
- (void) doReloadDomain: (NSWindow*) sheet
			 returnCode: (int) returnCode
			contextInfo: (void*) contextInfo;
- (IBAction)reloadDomain:(id)sender;
- (void) doSaveDomain: (DXDomainController*) domain;
- (IBAction)saveAllDomains:(id)sender;
- (IBAction)saveDomain:(id)sender;

- (IBAction) searchDomain: (id) sender;
- (IBAction) searchKey: (id) sender;

// return a sheet to edit the given key
- (NSWindow*) sheetForKey: (DXKey*) aKey;


// show the edit sheet, return its return code
// currentKey must be set first
- (int) doEditKey;
- (IBAction) keyDoubleClicked:(id)sender;

- (IBAction) sheetOKClicked:(id)sender;
- (IBAction) sheetCancelClicked:(id)sender;

- (IBAction) showAbout: (id) sender;

// show the sheet set as currentSheet
// return its return code
- (int) showCurrentSheet;

// is there a modified domain?
- (BOOL) modifiedDomainExists;

// used when a user confirms removal of a domain
- (void) doRemoveDomain: (NSWindow*) sheet
			 returnCode: (int) returnCode
			contextInfo: (void*) contextInfo;

// used when a user confirms removal of a key
- (void) doRemoveKey: (NSWindow*) sheet
		  returnCode: (int) returnCode
		 contextInfo: (void*) contextInfo;

- (DXDomainController*) domainForName: (NSString*) domainName;
- (DXDomainController*) currentDomain;
- (int) indexOfDomain: (NSString*) domainName;

// basic actions
- (void) addDomain: (DXDomainEnvelope*) aDomain;
- (void) removeDomain: (DXDomainEnvelope*) aDomain;
- (void) addKey: (DXKey*) aKey;
- (void) removeKey: (DXKey*) aKey;

// first item = key to be replaced, second item = the new key
// both must be objects of type DXKeyEnvelope
// and must have the same parent and domain
- (void) replaceKeys: (NSArray*) theKeys;

// go to home page
- (IBAction) goToHomePage: (id) sender;





@end
