//
//  DXDomainController.h
//  DefEcs
//
//  Created by ttomek on 06-07-30.
//  Copyright 2006 hipercom.pl. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "DXKey.h"


@interface DXDomainController : NSObject <NSCoding>
{
	NSString* name;
	DXKey* rootKey;
	NSOutlineView* domainContentsView;
	BOOL modified;
}

// designated initializer
- (id) initWithDomain: (NSString*) domainName
			 contents: (NSDictionary*) domainContents
		 contentsView: (NSOutlineView*) contentsView;

// loads contents from the defaults database
// and calls the designated initializer
- (id) initWithDomain: (NSString*) domainName
		 contentsView: (NSOutlineView*) contentsView;

// used when importing from a file
- (id) initWithCoder: (NSCoder*) coder;

// used when exporting to a file
- (void) encodeWithCoder: (NSCoder*) coder;

// load a persistent domain with the specified name
+ (NSDictionary*) loadDomainForName: (NSString*) theName;

- (void) reloadDomain;
- (NSString*) name;
- (DXKey*) rootKey;
- (int) count;
- (BOOL) modified;
- (void) setModified: (BOOL) isModified;
- (NSOutlineView*) domainContentsView;
- (void) setDomainContentsView: (NSOutlineView*) newView;
- (id) databaseRepresentation;

// domain contents view data source methods
- (id) outlineView: (NSOutlineView *)outlineView 
			 child: (int)index 
			ofItem: (id)item;
- (BOOL) outlineView: (NSOutlineView *) outlineView 
	isItemExpandable: (id)item;
- (int)			outlineView: (NSOutlineView *) outlineView 
	 numberOfChildrenOfItem:(id)item;
- (id)				outlineView: (NSOutlineView *) outlineView 
	  objectValueForTableColumn: (NSTableColumn *) tableColumn 
						 byItem: (id)item;

@end
