//
//  DXDomainController.m
//  DefEcs
//
//  Created by ttomek on 06-07-30.
//  Copyright 2006 hipercom.pl. All rights reserved.
//

#import "DXDomainController.h"
#import "DXStrings.h"

@implementation DXDomainController

- (id) initWithDomain: (NSString*) domainName
			 contents: (NSDictionary*) domainContents
		 contentsView: (NSOutlineView*) contentsView
{
	if (self = [super init])
	{
		name = [domainName copy];
		rootKey = [[DXKey alloc] initWithName: nil
										value: domainContents
									   parent: nil
									   domain: name];
		domainContentsView = contentsView;
		[self setModified: NO];
	}
	return self;
}

- (id) initWithDomain: (NSString*) domainName
		 contentsView: (NSOutlineView*) contentsView
{
	return [self initWithDomain: domainName
					   contents: [DXDomainController loadDomainForName: domainName]
				   contentsView: contentsView];
}

- (id) initWithCoder: (NSCoder*) coder
{
	if (self = [super init])
	{
		name = [[coder decodeObject] retain];
		rootKey = [[coder decodeObject] retain];
		domainContentsView = nil;
		modified = YES;
	}
	return self;
}

- (void) encodeWithCoder: (NSCoder*) coder
{
	[coder encodeObject: name];
	[coder encodeObject: rootKey];
}

+ (NSDictionary*) loadDomainForName: (NSString*) theName
{
	NSUserDefaults* defaults;
	NSDictionary* contents;
	defaults = [NSUserDefaults standardUserDefaults];
	contents = [defaults persistentDomainForName: theName];
	if (contents == nil)
		contents = [[NSDictionary alloc] init];
	return contents;
}

- (void) reloadDomain
{
	[rootKey release];
	rootKey = [[DXKey alloc] initWithName: nil
									value: [[self class] loadDomainForName: name]
								   parent: nil
								   domain: name];
	[self setModified: NO];
}

- (void) dealloc
{
	[rootKey release];
	[name release];
	[super dealloc];
}

- (NSString*) name
{
	return name;
}

- (DXKey*) rootKey
{
	return rootKey;
}

- (int) count
{
	return [rootKey count];
}

- (BOOL) modified
{
	return modified;
}

- (void) setModified: (BOOL) isModified
{
	modified = isModified;
}

- (NSOutlineView*) domainContentsView
{
	return domainContentsView;
}
- (void) setDomainContentsView: (NSOutlineView*) newView
{
	domainContentsView = newView;
}

- (id) databaseRepresentation
{
	return [rootKey databaseRepresentation];
}

- (id) outlineView: (NSOutlineView *)outlineView 
			 child: (int)index 
			ofItem: (id)item
{
	// root is our key dictionary
	if (item == nil)
		item = rootKey;
	return [item childAtIndex: index];
}

- (BOOL) outlineView: (NSOutlineView *) outlineView 
	isItemExpandable: (id)item
{
	if (item == nil)
		return NO;
	else
		return [item isCompound];
}

- (int)			outlineView: (NSOutlineView *) outlineView 
	 numberOfChildrenOfItem: (id) item
{
	if (item == nil)
		item = rootKey;
	return [item count];
}

- (id)				outlineView: (NSOutlineView *) outlineView 
	  objectValueForTableColumn: (NSTableColumn *) tableColumn 
						 byItem: (id)item
{
	NSString* columnId;
	columnId = [tableColumn identifier];
	if ([columnId isEqualToString: @"keyName"])
		return [item nameDescription];
	else if ([columnId isEqualToString: @"keyType"])
		return [item typeName];
	else if ([columnId isEqualToString: @"keyValue"])
		return [item valueDescription];
	else
		return nil;
}

@end
