//
//  DXDomainEnvelope.m
//  DefEcs
//
//  Created by ttomek on 06-08-07.
//  Copyright 2006 hipercom.pl. All rights reserved.
//

#import "DXDomainEnvelope.h"


@implementation DXDomainEnvelope

- (id) initWithDomainName: (NSString*) aName 
				 contents: (NSDictionary*) theContents
{
	if (self = [super init])
	{
		name = [aName copy];
		contents = [theContents retain];
	}
	return self;
}

- (id) initWithDomainName: (NSString*) aName
{
	return [self initWithDomainName: aName
						   contents: [[[NSDictionary alloc] init] autorelease]
		];
}

- (id) init
{
	return [self initWithDomainName: @""];
}

- (void) dealloc
{
	[name release];
	[contents release];
	[super dealloc];
}

- (NSString*) name
{
	return name;
}

- (void) setName: (NSString*) newName
{
	[newName retain];
	[name release];
	name = newName;
}

- (NSDictionary*) contents
{
	return contents;
}

- (void) setContents: (NSDictionary*) newContents
{
	[newContents retain];
	[contents release];
	contents = newContents;
}

@end
