//
//  DXKey.h
//  DefEcs
//
//  Created by ttomek on 06-08-18.
//  Copyright 2006 hipercom.pl. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "DXStrings.h"


@interface DXKey : NSObject <NSCoding>
{
	NSString* domain;
	id name;
	id value;
	DXKey* parent;
}

- (id) initWithName: (id) aName
			  value: (id) aValue
			 parent: (DXKey*) aParent
			 domain: (NSString*) aDomain;

- (void) encodeWithCoder: (NSCoder*) coder;
- (id) initWithCoder: (NSCoder*) coder;

- (BOOL) isCompound;
- (BOOL) isArray;
- (BOOL) isDictionary;
- (id) name;
- (NSString*) nameDescription;
- (id) value;
- (NSString*) valueDescription;
- (DXKey*) parent; // nil for the root key
- (void) setParent: (DXKey*) aParent;
- (NSString*) domain;
- (int) count;
- (DXKey*) childAtIndex: (int) index;
- (DXKey*) childForName: (id) aName;
- (void) addKey: (DXKey*) newKey forName: (id) keyName;
- (void) addKey: (DXKey*) newKey;
- (void) removeKey: (DXKey*) aKey;
- (void) replaceKey: (DXKey*) oldKey withKey: (DXKey*) newKey;
- (NSString*) typeName;
- (void) performForAll: (SEL) aSelector withObject: (id) anArgument;
- (id) databaseRepresentation;
- (BOOL) keyExists: (id) keyName;

+ (BOOL) isObjectArray: (id) anObject;
+ (BOOL) isObjectDictionary: (id) anObject;
+ (BOOL) isObjectCompound: (id) anObject;

+ (BOOL) isObjectString: (id) anObject;
+ (BOOL) isObjectBoolean: (id) anObject;
+ (BOOL) isObjectNumber: (id) anObject;
+ (BOOL) isObjectDate: (id) anObject;
+ (BOOL) isObjectData: (id) anObject;
+ (NSString*) valueTypeName: (id) aValue;


+ (id) processValue: (id) aValue forKey: (DXKey*) aKey;

@end
