#import "DXNumberController.h"
#include <math.h>

@implementation DXNumberController

- (void) setNumber: (NSNumber*) aNumber
{
	if ([aNumber boolValue])
		[booleanValue selectCellWithTag: 0];
	else
		[booleanValue selectCellWithTag: 1];
	
	[integerValue setIntValue: [aNumber intValue]];
	[realValue setFloatValue: [aNumber floatValue]];
	
	NSString *className;
	className = NSStringFromClass([aNumber class]);
	if ([className isEqualToString: @"NSCFBoolean"])
	{
		[typeTabs selectTabViewItemWithIdentifier: @"3"];
	}
	else
	{
		float fv;
		int iv;
		fv = [aNumber floatValue];
		iv = [aNumber intValue];
		if (fv == floorf(fv))
		{
			[typeTabs selectTabViewItemWithIdentifier: @"1"];
		}
		else
		{
			[typeTabs selectTabViewItemWithIdentifier: @"2"];
		}
	}
}

- (NSNumber*) number
{
	NSString* selectedTabId;
	selectedTabId = [[typeTabs selectedTabViewItem] identifier];
	if ([selectedTabId isEqualToString: @"1"])
	{
		return [NSNumber numberWithInt: [integerValue intValue]];
	}
	else if ([selectedTabId isEqualToString: @"2"])
	{
		return [NSNumber numberWithFloat: [realValue floatValue]];
	}
	else
	{
		if ([[booleanValue selectedCell] tag] == 0)
			return [NSNumber numberWithBool: YES];
		else
			return [NSNumber numberWithBool: NO];
	}
}



@end
