#import <Cocoa/Cocoa.h>
#import "X24View.h"
#import "X24Window.h"
#import "X24Connector.h"

#define X24VERSION @"1.2"
#define X24VERSIONURL @"http://www.hipercom.pl/x24/version.txt"
#define X24PAGE @"http://www.hipercom.pl/x24"

@interface X24AppController : NSObject {
	
	IBOutlet NSPanel* preferencesPanel;
	IBOutlet X24Window* pagerWindow;
	
	X24Connector* connector;
}

// show the user preferences
- (IBAction) showPreferencesPanel: (id) sender;

// when the user clicks "Apply" in the preferences
- (IBAction) applyPreferences: (id) sender;

// show/hide pager window
- (IBAction) showPagerWindow: (id) sender;
- (IBAction) hidePagerWindow: (id) sender;

// launch www.tvn24.pl in Safari
- (IBAction) goToWebPage: (id) sender;

// check the version
- (IBAction) checkversion: (id) sender;

// return the names of the pager positions, to be displayed
// in a combo in the preferences window (binding)
- (NSArray*) possiblePositions;

// return the entry in the loginwindow persistent domain,
// which causes the pager to launch after login
- (NSDictionary*) myLoginWindowEntry;

// enable/disable autostart of the pager, depending on the user preference
- (void) setStartAtLogin;

@end
