#import "X24AppController.h"

static NSArray* possiblePositions = nil;



@implementation X24AppController

+ (void) initialize
{
	// possible pager positions (binding used by a combo in the preferences window)
	possiblePositions = [[NSArray arrayWithObjects:
		NSLocalizedString(@"Top (below the menu bar)",@"[1]"),
		NSLocalizedString(@"Bottom (above the dock)",@"[1]"),
		NSLocalizedString(@"Bottom of the screen",@"[1]"),
		nil
		] retain];

	// register factory defaults
	NSData* pagerColor = [NSArchiver archivedDataWithRootObject:
		[NSColor blueColor]];
	NSData* textColor = [NSArchiver archivedDataWithRootObject:
		[NSColor whiteColor]];
	
	NSDictionary* defs = [NSDictionary dictionaryWithObjectsAndKeys:
		pagerColor, @"pagerColor",
		textColor, @"textColor",
		[NSNumber numberWithInt: 1], @"pagerSize",
		[NSNumber numberWithInt: 0], @"pagerPosition",
		[NSNumber numberWithFloat: 0.5], @"pagerAlpha",
		@"http://www.tvn24.pl/%d,messages-v2.xml", @"messagesURL",
		[NSNumber numberWithBool: NO], @"startAtLogin",
		[NSNumber numberWithInt: 2], @"scrollingSpeed",
		[NSNumber numberWithBool: YES], @"stayOnTop",
		[NSNumber numberWithBool: NO], @"startAtLogin",
		nil];
	[[NSUserDefaults standardUserDefaults] registerDefaults: defs];
	
	
}

- (IBAction) showPreferencesPanel: (id) sender
{
	if ([NSBundle loadNibNamed: @"preferences" owner: self])
	{
		[preferencesPanel orderFront: self];
	}
}

- (IBAction) applyPreferences: (id) sender
{
	[[NSUserDefaults standardUserDefaults] synchronize];
	[[NSNotificationCenter defaultCenter] postNotificationName: @"X24PreferencesChanged"
														object: self];
	[self setStartAtLogin];
}


- (IBAction) showPagerWindow: (id) sender
{
	if (![pagerWindow isVisible])
		[pagerWindow orderFront: self];
}

- (IBAction) hidePagerWindow: (id) sender
{
	if ([pagerWindow isVisible])
		[pagerWindow orderOut: self];
}

- (IBAction) goToWebPage: (id) sender
{
	[[NSWorkspace sharedWorkspace] openURL: [NSURL URLWithString: @"http://www.tvn24.pl"]];
}

- (IBAction) checkversion: (id) sender
{
	// update checks removed, don't work anyway
}

- (NSArray*) possiblePositions
{
	return possiblePositions;
}

// start the fun!
- (void) letItGo: (NSTimer*) t
{
	[t invalidate];
	[[NSNotificationCenter defaultCenter] postNotificationName: @"X24PreferencesChanged" object: self];
	[[NSNotificationCenter defaultCenter] postNotificationName: @"X24AllMessagesDisplayed" object: self];
}

- (void) dealloc
{
	[possiblePositions release];
	if (connector)
		[connector release];
	[super dealloc];
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
	[pagerWindow setup];
	[pagerWindow orderFront: self];
	connector = [[X24Connector alloc] init];
	// give everyone some time to prepare
	[NSTimer scheduledTimerWithTimeInterval: 1.0
									 target: self
								   selector: @selector(letItGo:)
								   userInfo: nil
									repeats: NO];
}

#define AUTOSTART_TABLE_KEY @"AutoLaunchedApplicationDictionary"

- (NSDictionary*) myLoginWindowEntry
{
	NSString* fullPath = [[NSBundle mainBundle] bundlePath];
	return [NSDictionary dictionaryWithObjectsAndKeys:
		fullPath, @"Path",
		[NSNumber numberWithBool: NO], @"Hide",
		nil];
}

- (void) removeMeFromLoginItems
{
	NSMutableDictionary* loginWindow = 
	[[[NSUserDefaults standardUserDefaults] persistentDomainForName: @"loginwindow"] mutableCopy];
	NSMutableArray* loginItems = [[loginWindow objectForKey: AUTOSTART_TABLE_KEY] mutableCopy];
	NSDictionary* myEntry = [self myLoginWindowEntry];
	int i;
	for (i = 0; i < [loginItems count]; i++)
	{
		NSDictionary* item = [loginItems objectAtIndex: i];
		NSString* path = [item objectForKey: @"Path"];
		NSRange found = [path rangeOfString: [myEntry objectForKey: @"Path"]];
		if (found.location != NSNotFound)
		{
			[loginItems removeObjectAtIndex: i];
			i--;
		}
	}
	[loginWindow setObject: loginItems forKey: AUTOSTART_TABLE_KEY];
	[[NSUserDefaults standardUserDefaults] setPersistentDomain: loginWindow forName: @"loginwindow"];
	[[NSUserDefaults standardUserDefaults] synchronize];
}

- (void) addMeToLoginItems
{
	NSMutableDictionary* loginWindow = 
	[[[NSUserDefaults standardUserDefaults] persistentDomainForName: @"loginwindow"] mutableCopy];
	NSMutableArray* loginItems = [[loginWindow objectForKey: AUTOSTART_TABLE_KEY] mutableCopy];
	NSDictionary* myEntry = [self myLoginWindowEntry];
	[loginItems addObject: myEntry];
	[loginWindow setObject: loginItems forKey: AUTOSTART_TABLE_KEY];
	[[NSUserDefaults standardUserDefaults] setPersistentDomain: loginWindow forName: @"loginwindow"];
	[[NSUserDefaults standardUserDefaults] synchronize];	
}

- (void) setStartAtLogin
{
	[self removeMeFromLoginItems];
	if ([[NSUserDefaults standardUserDefaults] boolForKey: @"startAtLogin"])
		[self addMeToLoginItems];
}


@end
