#import <Cocoa/Cocoa.h>


@interface X24Connector : NSObject {
	NSString* messagesURL;
}

// returns a single "connecting to TVN24..." message
// used when connection problems occur
- (NSArray*) connectingMessage;

// posts a notification
- (void) notifyAboutNewMessages: (id) newMessages;

// executed by downloadMessages in a separate thread
- (void) startDownloadingMessages;

// starts a separate thread, in which messages are downloaded
// and analyzed
// call this one only, leave alone startDownloadingMessages
- (void) downloadMessages;

// schedule reloading in a separate thread
- (void) allMessagesDisplayedNotificationHandler: (NSNotification*) n;

// traverses the downloaded XML file and retrieves the messages
// each message is a dictionary - see comments in X24Connector.m
- (NSArray*) decodeXMLMessagesFromDocument: (NSXMLDocument*) doc;

/* decodeMessages: is no longer used - deprecated by decodeXMLMessagesFromDocument: */
//- (NSArray*) decodeMessages: (NSString*) msgs;
@end
