#import <Cocoa/Cocoa.h>


@interface X24View : NSView {
	NSArray* messages; // most recent messages
	
	NSMutableArray* preparedImages;	// the array of prepared images to be scrolled
								// each entry is a dictionary with keys:
								// @"width" - image width (float NSNumber)
								// @"offset" - image offset (X coord) (float NSNumber)
								// @"image" - prepared NSImage
	float totalWidth;	// total width of the scrolled content
	
	NSImage* separatorNormal; // the normal separator background
	NSImage* separatorUrgent; // the separator background for urgent news
	float deltaX; // the offset of a single scroll (defines scrolling speed)
	float currentX; // the current offset in preparedImage
	NSTimer* animationTimer; // the timer used to animate the pager, set to match the refresh
	NSColor* textColor; // the color of the displayed messages
	int pagerSize; // the size of the pager (0=small, 1=medium, 2=large)
	NSFont* separatorFont; // the font of the separator symbols
	int firstVisibleImageIndex; // the index of the first image, which overlaps with the viewport
}

- (id) initWithFrame: (NSRect) frameRect;

// read the user preferences (scrolling speed and text color)
- (void) readPreferences;

// notification handlers - usually call processMessages to re-create preparedImage
- (void) preferencesChangedNotificationHandler: (NSNotification*) n;
- (void) messagesChangedNotificationHandler: (NSNotification*) n;
- (void) stopAnimationNotificationHandler: (NSNotification*) n;
- (void) startAnimationNotificationHandler: (NSNotification*) n;
- (void) pagerSizeChangedNotificationHandler: (NSNotification*) n;

// prepare a cathegory separator
// used internally by processMessages
- (NSImage*) makeSeparator:(NSString*) separatorText urgent:(BOOL)isUrgent;

// prepares the image to be scrolled, using the messages array
// each message is a dictionary with @"TEXT" and @"CATHEGORY" keys
// @"CATHEGORY" determines the separator image
- (void) processMessages;

// performs a single step of the pager animation
- (void) animationStep: (NSTimer*) t;

@end
