#import <Cocoa/Cocoa.h>
#import "X24View.h"

@interface X24Window : NSWindow {

	IBOutlet NSButton* minimizeButton;
	IBOutlet X24View* pagerView;
	
	BOOL isMinimized;
}

// initializes a borderless, semi-transparent window
- (id) initWithContentRect: (NSRect) contentRect 
				 styleMask: (unsigned int) aStyle 
				   backing: (NSBackingStoreType) bufferingType 
					 defer: (BOOL) flag;

// set position and size basing on the preferences
- (void) setPositionAndSize;

// set up the window - read preferences, set colors and position
- (void) setup;

- (NSButton*) minimizeButton;
- (void) setMinimizeButton: (NSButton*) newButton;
- (X24View*) pagerView;
- (void) setPagerView: (X24View*) newView;

// minimize the pager to the left side of the screen
- (IBAction) minimizeClicked: (id) sender;

@end
