#import "X24Window.h"

int pagerSizes[] = {
	20,
	40,
	60
};


@implementation X24Window

- (id) initWithContentRect: (NSRect) contentRect 
				 styleMask: (unsigned int) aStyle 
				   backing: (NSBackingStoreType) bufferingType 
					 defer: (BOOL) flag 
{	
    NSWindow* result = [super initWithContentRect:contentRect styleMask:NSBorderlessWindowMask backing:NSBackingStoreBuffered defer:NO];
    [result setBackgroundColor: [NSColor blueColor]];
	BOOL stayOnTop = [[NSUserDefaults standardUserDefaults] boolForKey: @"stayOnTop"];
	if (stayOnTop)
		[result setLevel: NSStatusWindowLevel];
	else
		[result setLevel: NSNormalWindowLevel];
    [result setAlphaValue:0.5];
    [result setOpaque:NO];
    [result setHasShadow: YES];
	isMinimized = NO;
    return result;
}

- (BOOL) canBecomeKeyWindow
{
    return NO;
}

- (void) setPositionAndSize
{
	int sizeCode, positionCode;
	sizeCode = [[NSUserDefaults standardUserDefaults] integerForKey: @"pagerSize"];
	positionCode = [[NSUserDefaults standardUserDefaults] integerForKey: @"pagerPosition"];
	if (sizeCode < 0)
		sizeCode = 0;
	else if (sizeCode > 2)
		sizeCode = 2;
	if (positionCode < 0)
		positionCode = 0;
	else if (positionCode > 2)
		positionCode = 2;
	NSScreen* scr = [NSScreen mainScreen];
	NSRect screenBounds;
	NSRect pagerBounds;
	NSRect minimizeButtonBounds;
	NSRect pagerViewBounds;
	
	//NSLog(@"Window size code: %d, position code: %d",sizeCode,positionCode);
	
	pagerBounds.size.height = pagerSizes[sizeCode];
	//NSLog(@"Pager window height: %f", pagerBounds.size.height);
	
	screenBounds = [scr visibleFrame];
	if (positionCode < 2)
	{
		if (positionCode == 0)
			pagerBounds.origin.y = screenBounds.origin.y + screenBounds.size.height - pagerBounds.size.height;
		else
			pagerBounds.origin.y = screenBounds.origin.y;
	}
	else
	{
		pagerBounds.origin.y = 0;
	}
	pagerBounds.origin.x = screenBounds.origin.x;
	pagerBounds.size.width = screenBounds.size.width;
	
	minimizeButtonBounds.origin.x = 0;
	minimizeButtonBounds.origin.y = 0;
	minimizeButtonBounds.size.width = 20;
	minimizeButtonBounds.size.height = pagerBounds.size.height;
	
	pagerViewBounds.origin.x = minimizeButtonBounds.size.width;
	pagerViewBounds.origin.y = 0;
	pagerViewBounds.size.width = pagerBounds.size.width - minimizeButtonBounds.size.width;
	pagerViewBounds.size.height = pagerBounds.size.height;
	//NSLog(@"pagerBounds: (%f,%f), %f x %f", pagerBounds.origin.x, pagerBounds.origin.y, pagerBounds.size.width, pagerBounds.size.height);
	//NSLog(@"pagerViewBounds: (%f,%f), %f x %f", pagerViewBounds.origin.x, pagerViewBounds.origin.y, pagerViewBounds.size.width, pagerViewBounds.size.height);
	
	[self setFrame: pagerBounds display: YES];
	[minimizeButton setFrame:minimizeButtonBounds];
	[pagerView setFrame:pagerViewBounds];
}

- (void) setup
{
	NSColor* bgnd;
	float alpha;
	BOOL stayOnTop;
	NSUserDefaults* udef;
	udef = [NSUserDefaults standardUserDefaults];
	NS_DURING
		bgnd = [NSUnarchiver unarchiveObjectWithData: [udef dataForKey: @"pagerColor"]];
	NS_HANDLER
		bgnd = [NSColor blueColor];
	NS_ENDHANDLER
	
	alpha = [udef floatForKey: @"pagerAlpha"];
	stayOnTop = [[NSUserDefaults standardUserDefaults] boolForKey: @"stayOnTop"];
	
	[self setBackgroundColor: bgnd];
	[self setAlphaValue: alpha];
	[self setPositionAndSize];
	if (stayOnTop)
		[self setLevel: NSStatusWindowLevel];
	else
		[self setLevel: NSNormalWindowLevel];
	[self orderOut: self];
	[self orderFront: self];
}

- (NSButton*) minimizeButton
{
	return minimizeButton;
}

- (void) setMinimizeButton: (NSButton*) newButton
{
	NSButton* oldButton = minimizeButton;
	[newButton retain];
	minimizeButton = newButton;
	[oldButton release];
}

- (X24View*) pagerView
{
	return pagerView;
}

- (void) setPagerView: (X24View*) newView
{
	X24View* oldView = pagerView;
	[newView retain];
	pagerView = newView;
	[oldView release];
}

- (void) preferencesChangedNotificationHandler: (NSNotification*) n
{
	[self setup];
	[[NSNotificationCenter defaultCenter] postNotificationName: @"X24PagerSizeChanged"
														object: self];
}

- (void) dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver: self];
	[super dealloc];
}

- (void) awakeFromNib
{
	[[NSNotificationCenter defaultCenter] 
		addObserver: self
		   selector: @selector(preferencesChangedNotificationHandler:)
			   name: @"X24PreferencesChanged"
			 object: nil];
}

- (IBAction) minimizeClicked: (id) sender
{
	NSRect fr = [self frame];
	if (isMinimized)
	{
		isMinimized = NO;
		fr.size.width = [[NSScreen mainScreen] visibleFrame].size.width;
		[self setFrame: fr display: YES animate: YES];
		[[NSNotificationCenter defaultCenter] postNotificationName: @"X24StartAnimation" object: self];
	}
	else
	{
		[[NSNotificationCenter defaultCenter] postNotificationName: @"X24StopAnimation" object: self];
		isMinimized = YES;
		NSRect bfr = [minimizeButton frame];
		fr.size.width = bfr.size.width;
		[self setFrame: fr display: YES animate: YES];
	}
}

@end
