#import <Cocoa/Cocoa.h>

@interface AppController : NSObject
{
    IBOutlet NSButton *deleteButton;
    IBOutlet NSTextField *dstFolderField;
    IBOutlet NSButton *newButton;
    IBOutlet NSButton *openButton;
    IBOutlet NSTableView *projectsTable;
    IBOutlet NSWindow *projectsWindow;
    IBOutlet NSArrayController *projListController;
    IBOutlet NSTextField *srcFolderField;
	IBOutlet NSMatrix* modeMatrix;
	IBOutlet NSPanel* scanningPanel;
	IBOutlet NSProgressIndicator* scanningIndicator;
	
	IBOutlet NSPanel* preferencesPanel;
	IBOutlet NSTextField* defaultFolderField;
	
	NSMutableArray* projList;
	
}
- (IBAction)checkForUpdates:(id)sender;
- (IBAction)deleteProject:(id)sender;
- (IBAction)openProject:(id)sender;
- (IBAction)showHideProjectList:(id)sender;
- (IBAction)rescanFolder:(id)sender;
- (IBAction)preferences:(id)sender;
- (IBAction)projectListDoubleClicked:(id)sender;
- (IBAction)chooseDefaultFolder:(id)sender;

- (NSMutableArray*) projList;
- (void) setProjList: (NSMutableArray*) newProjList;

+ (void) registerFactoryDefaults;

@end
