#import <Cocoa/Cocoa.h>

#define SXMODE_OVERWRITE   0
#define SXMODE_COMPLEMENT  1
#define SXMODE_SYNCHRONIZE 2

#define SXTYPE_NONEXISTING	-1
#define SXTYPE_FILE			0
#define SXTYPE_FOLDER		1
#define SXTYPE_LINK			2

/* Schedule is an array of dictionaries. Each dictionary has the following
   keys:
   @"src" - source file/folder location (absolute path)
   @"dst" - destination file/folder location (absolute path)
   @"attributes" - src attributes
   @"operation" - type of operation (symbol defined in MyDocument.m)
   @"status" - the status of the operation (symbol defined in MyDocument.m)
   @"icon" - entry symbol (file or directory)
   @"deleteFirst" - delete before copying (dst exists) value: NSNumber (YES or NO)
   @"setAttributes" - set the attributes on dst after copy; value: NSNumber (YES or NO)
*/

@interface MyDocument : NSDocument
{
	NSMutableDictionary* project;	// project parameters:
									// @"projectName" - the name of the project (NSString)
									// @"srcFolder" - source folder (NSString)
									// @"dstFolder" - destination folder (NSString)
									// @"mode" - synchronization mode (NSNumber)
	NSMutableArray* schedule;		// prepared schedule
	NSMutableArray* errors;			// schedule execution errors
	BOOL userStop;
	BOOL scheduleRunning;
	
	IBOutlet NSPanel* preparingSchedulePanel;
	IBOutlet NSProgressIndicator* preparingScheduleIndicator;
	IBOutlet NSTextField* operationCountField;
	
	IBOutlet NSPanel* executingSchedulePanel;
	IBOutlet NSProgressIndicator* executingScheduleIndicator;
	IBOutlet NSTextField* completedOperationsField;
	
	IBOutlet NSArrayController* scheduleController;
	IBOutlet NSTableView* scheduleTable;
	IBOutlet NSArrayController* errorsController;
	IBOutlet NSTableView* errorsTable;
	
	IBOutlet NSTabView* documentTabs;
		
}

// initialization and cleanup
+ (void) initialize;
- (void) dealloc;

////////////////////// overriden methods from NSDocument
// just added a hack to start the save panel always in
// the default synXer project folder
- (BOOL)prepareSavePanel:(NSSavePanel *)savePanel;
- (id) initWithType:(NSString*) typeName error:(NSError**) outError;
- (NSString *)windowNibName;
- (void)windowControllerDidLoadNib:(NSWindowController *) aController;
- (NSData *)dataRepresentationOfType:(NSString *)aType;
// calls super and posts a notification (that's why this method
// is also overriden, not only dataRepresentationOfType:
- (BOOL)saveToURL:(NSURL *)absoluteURL 
		   ofType:(NSString *)typeName 
 forSaveOperation:(NSSaveOperationType)saveOperation 
			error:(NSError **)outError;
- (BOOL) readFromData:(NSData*)data 
			   ofType:(NSString*)aType 
				error:(NSError**)error;
//////////////////////

// attribute accessors
- (NSMutableDictionary*) project;
- (void) setProject: (NSMutableDictionary*) newProject;
- (NSMutableArray*) schedule;
- (void) setSchedule:(NSMutableArray*)newSchedule;
- (NSMutableArray*) errors;
- (void) setErrors:(NSMutableArray*)newErrors;

// returns the number of available synchronization modes
// used by bindings in main window and document window
// to set up a NSMatrix of radio buttons
+ (NSArray*) availableModes;
- (NSArray*) availableModes;

// show the directory open sheet and return the selected folder
// or nil if the user canceled the selection
+ (NSString*) selectFolder;

// event handlers
- (IBAction) prepareScheduleForCurrentProject:(id)sender;
- (IBAction) stopPreparingSchedule: (id) sender;
- (IBAction) stopExecutingSchedule: (id) sender;
- (IBAction) chooseSrcFolder:(id)sender;
- (IBAction) chooseDstFolder:(id)sender;
- (IBAction) scheduleTableDoubleClicked:(id)sender;
- (IBAction) executeScheduleForCurrentProject:(id)sender;
- (IBAction) closeProject:(id)sender;
@end
